# 景点日报

## 项目介绍

景点日报是一个模仿报纸布局的景点信息展示网页，采用现代化的Bento Grid布局设计，结合了Framer Motion动画效果，为用户提供丰富的景点信息和旅游指南。

## 功能特点

- **响应式设计**：适配各种屏幕尺寸，从手机到桌面设备
- **Bento Grid布局**：采用现代化的便当盒网格布局，视觉效果丰富多样
- **滚动触发动画**：模仿Apple官网的滚动触发动画效果，提升用户体验
- **高饱和度配色**：使用高饱和度的配色方案，营造科技感和现代感
- **大字体设计**：使用超大字体突出核心数据和信息，形成视觉焦点

## 技术栈

- HTML5
- TailwindCSS (通过CDN引入)
- Framer Motion (通过CDN引入)
- Font Awesome图标库
- JavaScript (原生)

## 项目结构

```
景点日报/
├── index.html      # 主页面
├── imgs/           # 图片资源目录
│   ├── yili_1.svg           # 伊犁风景图
│   ├── narati_1.svg         # 那拉提草原图
│   ├── yili_culture.svg     # 伊犁文化图
│   └── narati_activity.svg  # 那拉提活动图
└── README.md      # 项目说明文档
```

## 使用说明

### 查看网页

直接在浏览器中打开`index.html`文件即可查看网页效果。

### 修改景点信息

当需要更换展示的景点时，需要修改以下内容：

1. **图片资源**：替换`imgs`目录下的图片文件，或修改SVG文件中的内容
2. **页面标题**：修改`<h2>`标签中的主标题和副标题
3. **景点描述**：更新各个Bento Grid卡片中的景点描述文本
4. **数据信息**：更新游客量、景区面积等数据
5. **特色活动**：根据新景点的特色活动更新列表
6. **交通和住宿信息**：更新为新景点的相关信息

## 自定义样式

网页使用了CSS变量定义主要颜色，可以通过修改`:root`中的变量值来快速更改整个网页的配色方案：

```css
:root {
  --primary-color: #1e40af;    /* 主色调 */
  --secondary-color: #10b981;   /* 次要色调 */
  --accent-color: #f59e0b;      /* 强调色 */
  --text-color: #1f2937;        /* 文本颜色 */
  --bg-color: #f8fafc;          /* 背景色 */
}
```

## 注意事项

- 网页使用CDN引入外部资源，首次加载需要网络连接
- 为保证最佳体验，建议使用现代浏览器（Chrome、Firefox、Edge等）
- 修改SVG图片时，请保持原有的宽高比例，以免影响布局

## 创作者

@秋芝2046

## 数据来源

- 中华人民共和国文化和旅游部
- 新疆维吾尔自治区人民政府